# 🎨 Admin Panel Preview

## 🔐 Login Page
```
┌─────────────────────────────────────────┐
│                                         │
│         🔐 Admin Panel                  │
│     Ensi.lk Management System           │
│                                         │
│  ┌────────────────────────────────┐    │
│  │ Username                        │    │
│  │ [admin                      ]   │    │
│  └────────────────────────────────┘    │
│                                         │
│  ┌────────────────────────────────┐    │
│  │ Password                        │    │
│  │ [••••••••                   ]   │    │
│  └────────────────────────────────┘    │
│                                         │
│  ┌────────────────────────────────┐    │
│  │   Login to Admin Panel         │    │
│  └────────────────────────────────┘    │
│                                         │
│  🔒 This is a restricted area.          │
│     All activities are logged.          │
│                                         │
│   © 2024 Ensi.lk - Admin Panel v1.0    │
└─────────────────────────────────────────┘
```

## 📊 Dashboard
```
╔═══════════════════════════════════════════════════════════╗
║  Ensi.lk Admin  │ 📊 Dashboard │ 👥 Users │ 📋 Logs      ║
║                                         👤 admin [Logout] ║
╠═══════════════════════════════════════════════════════════╣
║                                                           ║
║  Dashboard                                                ║
║  Welcome back, Administrator!                             ║
║                                                           ║
║  ┌──────────┐  ┌──────────┐  ┌──────────┐  ┌──────────┐ ║
║  │ 👥       │  │ ✅       │  │ 📅       │  │ 🗑️      │ ║
║  │  156     │  │  142     │  │    8     │  │    3     │ ║
║  │Total     │  │Verified  │  │New Today │  │Deleted   │ ║
║  │Users     │  │Users     │  │          │  │Users     │ ║
║  └──────────┘  └──────────┘  └──────────┘  └──────────┘ ║
║                                                           ║
║  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓ ║
║  ┃ Recent Users                    [View All Users]   ┃ ║
║  ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫ ║
║  ┃ ID │ Name      │ Email           │ Level  │ Status ┃ ║
║  ┃────┼───────────┼─────────────────┼────────┼────────┃ ║
║  ┃ 89 │ John Doe  │ john@email.com  │Level 3 │✅ Ver. ┃ ║
║  ┃ 88 │ Jane Smith│ jane@email.com  │Level 1 │✅ Ver. ┃ ║
║  ┃ 87 │ Bob Wilson│ bob@email.com   │Level 0 │⏳ Pend.┃ ║
║  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛ ║
╚═══════════════════════════════════════════════════════════╝
```

## 👥 User Management Page
```
╔═══════════════════════════════════════════════════════════╗
║  Ensi.lk Admin  │ 📊 Dashboard │ 👥 Users │ 📋 Logs      ║
║                                         👤 admin [Logout] ║
╠═══════════════════════════════════════════════════════════╣
║                                                           ║
║  Manage Users                          [+ Add User]       ║
║                                                           ║
║  ┌─────────────────────────────────────────────────────┐ ║
║  │ Filters:                                            │ ║
║  │ [Search by name or email...] [All Levels▼]         │ ║
║  │ [All Status▼] [Filter] [Clear]                     │ ║
║  └─────────────────────────────────────────────────────┘ ║
║                                                           ║
║  Found 156 user(s)                                        ║
║                                                           ║
║  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓ ║
║  ┃ID │ 📷│ Name  │ Email       │Level │Status│Actions ┃ ║
║  ┣━━━╋━━━╋━━━━━━━╋━━━━━━━━━━━━━╋━━━━━━╋━━━━━━╋━━━━━━━┫ ║
║  ┃89 │🙂│John D.│john@e.com   │Lv 3  │✅ Ver│✏️🗑️  ┃ ║
║  ┃88 │😊│Jane S.│jane@e.com   │Lv 1  │✅ Ver│✏️🗑️  ┃ ║
║  ┃87 │🎯│Bob W. │bob@e.com    │Lv 0  │⏳ Pen│✏️🗑️  ┃ ║
║  ┃86 │😎│Alice J│alice@e.com  │Lv 5  │✅ Ver│✏️🗑️  ┃ ║
║  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛ ║
╚═══════════════════════════════════════════════════════════╝
```

## ➕ Add User Modal
```
        ┌──────────────────────────────┐
        │ Add New User             [×] │
        ├──────────────────────────────┤
        │                              │
        │  Name                        │
        │  [                        ]  │
        │                              │
        │  Email                       │
        │  [                        ]  │
        │                              │
        │  Password                    │
        │  [                        ]  │
        │                              │
        │  User Level (0-10)           │
        │  [0                       ]  │
        │                              │
        │         [Cancel] [Add User]  │
        └──────────────────────────────┘
```

## ✏️ Edit User Modal
```
        ┌──────────────────────────────┐
        │ Edit User                [×] │
        ├──────────────────────────────┤
        │                              │
        │  Name                        │
        │  [John Doe              ]    │
        │                              │
        │  Email                       │
        │  [john@email.com        ]    │
        │                              │
        │  User Level (0-10)           │
        │  [3                     ]    │
        │                              │
        │  ☑ Email Verified            │
        │                              │
        │      [Cancel] [Update User]  │
        └──────────────────────────────┘
```

## 📋 Activity Logs
```
╔═══════════════════════════════════════════════════════════╗
║  Ensi.lk Admin  │ 📊 Dashboard │ 👥 Users │ 📋 Logs      ║
║                                         👤 admin [Logout] ║
╠═══════════════════════════════════════════════════════════╣
║                                                           ║
║  Activity Logs                                            ║
║  Track all admin activities               1,234 total logs║
║                                                           ║
║  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓ ║
║  ┃ID │Admin    │Action      │Description   │Date/Time  ┃ ║
║  ┣━━━╋━────────╋────────────╋──────────────╋───────────┫ ║
║  ┃456│admin    │create_user │Created: john@│Oct 25 10:│ ║
║  ┃455│admin    │login       │Admin logged  │Oct 25 09:│ ║
║  ┃454│admin    │update_user │Updated ID: 88│Oct 24 16:│ ║
║  ┃453│admin    │delete_user │Deleted ID: 12│Oct 24 15:│ ║
║  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛ ║
║                                                           ║
║           [1] [2] [3] ... [25]                           ║
╚═══════════════════════════════════════════════════════════╝
```

## 🎨 Color Scheme

### Gradient Background
- Primary: `#667eea` (Purple)
- Secondary: `#764ba2` (Deep Purple)

### User Level Badges
- Level 0: Gray (#e0e0e0)
- Level 1: Light Blue (#b3e5fc)
- Level 2: Teal (#b2dfdb)
- Level 3: Green (#c8e6c9)
- Level 4: Light Green (#dcedc8)
- Level 5: Yellow (#fff9c4)
- Level 6: Orange (#ffe0b2)
- Level 7: Deep Orange (#ffccbc)
- Level 8: Pink (#f8bbd0)
- Level 9: Purple (#e1bee7)
- Level 10: Gradient (Purple to Pink)

### Status Badges
- ✅ Verified: Green (#d4edda)
- ⏳ Pending: Yellow (#fff3cd)
- 🗑️ Deleted: Red (#f8d7da)

## 📱 Responsive Design

The admin panel is fully responsive and works on:
- 💻 Desktop (1920x1080 and above)
- 💻 Laptop (1366x768 and above)
- 📱 Tablet (768x1024)
- 📱 Mobile (375x667)

## ⌨️ Keyboard Shortcuts

- `Tab` - Navigate between fields
- `Enter` - Submit forms
- `Esc` - Close modals
- `Ctrl+F` - Focus search box (in user management)

## 🎯 User Experience Features

✅ Auto-focus on first input field
✅ Real-time form validation
✅ Smooth animations and transitions
✅ Loading states for async operations
✅ Success/error notifications
✅ Confirmation dialogs for destructive actions
✅ Auto-hide alerts after 5 seconds
✅ Sticky navigation bar
✅ Hover effects on buttons and cards
✅ Color-coded badges for quick identification
