# 🔒 Admin Panel Security Checklist

## ⚠️ Critical - Do These First!

### 1. Change Default Password ⚠️
```sql
-- Generate new hash in PHP:
-- php -r "echo password_hash('YOUR_NEW_PASSWORD', PASSWORD_DEFAULT);"

UPDATE admins 
SET password_hash = 'your_generated_hash_here' 
WHERE username = 'admin';
```

**Status:** [ ] Not Done  [ ] Completed

---

### 2. Create Personal Admin Account
```sql
-- Replace with your details
INSERT INTO admins (username, password_hash, full_name, email, role) 
VALUES (
    'your_username', 
    '$2y$10$...your_password_hash...', 
    'Your Full Name', 
    'your@email.com', 
    'super_admin'
);
```

**Status:** [ ] Not Done  [ ] Completed

---

### 3. Delete Default Admin Account
```sql
-- Only after creating your own account!
DELETE FROM admins WHERE username = 'admin';
```

**Status:** [ ] Not Done  [ ] Completed

---

## 🛡️ Important Security Measures

### 4. Secure config.php
```bash
# Set strict permissions
chmod 600 admin/config.php

# Verify .htaccess blocks direct access
curl https://www.howdoyou.space/admin/config.php
# Should return 403 Forbidden
```

**Status:** [ ] Not Done  [ ] Completed

---

### 5. Enable HTTPS
Add to `.htaccess`:
```apache
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

**Status:** [ ] Not Done  [ ] Completed

---

### 6. IP Whitelist (Optional but Recommended)
Add to `.htaccess`:
```apache
# Allow only specific IPs
Order Deny,Allow
Deny from all
Allow from 123.456.789.0
Allow from 98.765.432.0
```

**Status:** [ ] Not Done  [ ] Skipped  [ ] Completed

---

### 7. Change Session Name
In `config.php`:
```php
// Use a unique session name (harder to guess)
define('ADMIN_SESSION_NAME', 'your_random_name_here');
```

**Status:** [ ] Not Done  [ ] Completed

---

### 8. Reduce Session Timeout (Optional)
In `config.php`:
```php
// Default is 1 hour (3600 seconds)
define('ADMIN_SESSION_TIMEOUT', 1800); // 30 minutes
```

**Status:** [ ] Not Done  [ ] Skipped  [ ] Completed

---

## 🔍 Ongoing Security Practices

### 9. Regular Password Changes
- [ ] Change admin passwords every 90 days
- [ ] Use strong passwords (12+ characters)
- [ ] Include uppercase, lowercase, numbers, symbols

**Last Changed:** ___________

---

### 10. Monitor Activity Logs
- [ ] Check logs daily for suspicious activity
- [ ] Look for failed login attempts
- [ ] Verify all admin actions are legitimate

**Last Checked:** ___________

---

### 11. Regular Backups
```sql
-- Backup admin tables
mysqldump -u playbdqv_engweb -p playbdqv_engweb admins admin_logs > admin_backup.sql
```

- [ ] Set up automated weekly backups
- [ ] Store backups in secure location
- [ ] Test restore process

**Last Backup:** ___________

---

### 12. Update Admin Software
- [ ] Keep PHP updated (8.1+)
- [ ] Monitor for security patches
- [ ] Test updates in staging environment first

**Last Updated:** ___________

---

## 🚨 Red Flags to Watch For

### Signs of Compromise:
- [ ] Failed login attempts from unknown IPs
- [ ] Admin actions you didn't perform
- [ ] Unexpected users being created/deleted
- [ ] Changes to admin accounts you didn't make
- [ ] Login times that don't match your activity

**Action if Compromised:**
1. Change all admin passwords immediately
2. Check admin_logs for unauthorized actions
3. Review all users for suspicious accounts
4. Enable IP whitelist
5. Review server logs for entry point

---

## 📋 Additional Hardening (Advanced)

### 13. Two-Factor Authentication (Future Enhancement)
- [ ] Plan to implement 2FA
- [ ] Use Google Authenticator or similar
- [ ] Require for all admin accounts

---

### 14. Rate Limiting
Already implemented in code:
- Maximum 5 login attempts
- 15-minute lockout after failed attempts

**Status:** ✅ Active

---

### 15. Database Security
```sql
-- Create separate read-only user for non-critical operations
CREATE USER 'ensi_readonly'@'localhost' IDENTIFIED BY 'strong_password';
GRANT SELECT ON playbdqv_engweb.users TO 'ensi_readonly'@'localhost';
```

**Status:** [ ] Not Done  [ ] Completed

---

### 16. SQL Injection Protection
✅ Already implemented:
- PDO prepared statements
- Parameter binding
- No raw SQL queries

**Status:** ✅ Active

---

### 17. XSS Protection
✅ Already implemented:
- `htmlspecialchars()` on all output
- Input sanitization
- No direct HTML rendering

**Status:** ✅ Active

---

### 18. CSRF Protection (Future Enhancement)
- [ ] Implement CSRF tokens
- [ ] Add token validation to all forms
- [ ] Regenerate tokens per session

---

## 🎯 Security Score

Count your completed items:

- **18-20 items**: 🟢 Excellent Security
- **15-17 items**: 🟡 Good Security
- **12-14 items**: 🟠 Moderate Security
- **Below 12**: 🔴 Needs Improvement

**Your Score:** _____ / 20

---

## 📞 Emergency Contacts

**Database Admin:** _______________
**Server Admin:** _______________
**Developer:** chanuxbro@gmail.com

---

## 🔐 Password Policy

Enforce these rules for all admin passwords:

✅ Minimum 12 characters
✅ At least 1 uppercase letter
✅ At least 1 lowercase letter
✅ At least 1 number
✅ At least 1 special character (!@#$%^&*)
✅ No common words or patterns
✅ No personal information
✅ Change every 90 days
✅ Don't reuse last 5 passwords

---

## 📝 Incident Response Plan

**If security breach detected:**

1. **Immediate Actions:**
   - [ ] Disable all admin accounts
   - [ ] Change database password
   - [ ] Enable maintenance mode
   - [ ] Backup current state

2. **Investigation:**
   - [ ] Review admin_logs
   - [ ] Check server access logs
   - [ ] Identify entry point
   - [ ] List affected data

3. **Recovery:**
   - [ ] Reset all admin passwords
   - [ ] Restore from clean backup if needed
   - [ ] Patch security vulnerability
   - [ ] Re-enable accounts

4. **Prevention:**
   - [ ] Document incident
   - [ ] Implement additional security
   - [ ] Monitor for repeat attempts
   - [ ] Update security procedures

---

## ✅ Pre-Launch Checklist

Before going live with admin panel:

- [ ] Default password changed
- [ ] Personal admin account created
- [ ] Default admin deleted
- [ ] HTTPS enabled
- [ ] config.php secured
- [ ] .htaccess working
- [ ] Session security configured
- [ ] Database backups scheduled
- [ ] Activity logs tested
- [ ] All CRUD operations tested
- [ ] Security checklist reviewed
- [ ] Emergency contacts documented
- [ ] Password policy established
- [ ] Incident response plan created

**Ready to Launch:** [ ] YES  [ ] NO

---

## 📖 Additional Resources

- [OWASP Top 10](https://owasp.org/www-project-top-ten/)
- [PHP Security Guide](https://www.php.net/manual/en/security.php)
- [MySQL Security](https://dev.mysql.com/doc/refman/8.0/en/security.html)
- [Apache Security](https://httpd.apache.org/docs/2.4/misc/security_tips.html)

---

**Last Security Review:** ___________
**Next Review Due:** ___________
**Reviewed By:** ___________
