<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';

echo "<h2>Debug Subscriptions Page</h2><hr>";

// Test 1: Config loaded
echo "✅ Config loaded<br>";

// Test 2: Check if functions.php exists
if (file_exists('includes/functions.php')) {
    echo "✅ functions.php exists<br>";
    require_once 'includes/functions.php';
    echo "✅ functions.php loaded<br>";
} else {
    echo "❌ functions.php NOT FOUND<br>";
    die();
}

// Test 3: Get PDO
try {
    $pdo = getDBConnection();
    if ($pdo) {
        echo "✅ Database connected<br>";
    } else {
        echo "❌ Database connection failed<br>";
        die();
    }
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "<br>";
    die();
}

// Test 4: Session and auth
session_start();
if (isset($_SESSION['admin_id'])) {
    echo "✅ Session exists: Admin ID = " . $_SESSION['admin_id'] . "<br>";
} else {
    echo "⚠️ No session - redirecting would happen here<br>";
}

// Test 5: Try the subscription query
echo "<hr><h3>Testing Subscription Query</h3>";
try {
    $query = "
        SELECT 
            s.id as subscription_id,
            s.status,
            s.payment_method,
            s.amount_paid,
            s.start_date,
            s.end_date,
            s.created_at,
            DATEDIFF(s.end_date, NOW()) as days_remaining,
            u.id as user_id,
            u.email,
            u.user_name,
            COALESCE(u.full_name, u.user_name, u.email) as display_name,
            p.package_name,
            p.duration_months
        FROM user_subscriptions s
        JOIN users u ON s.user_id = u.id
        JOIN subscription_packages p ON s.package_id = p.id
        ORDER BY s.created_at DESC
        LIMIT 10
    ";
    
    $stmt = $pdo->query($query);
    $subscriptions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "✅ Query executed - Found " . count($subscriptions) . " records<br>";
} catch (Exception $e) {
    echo "❌ Query failed: " . $e->getMessage() . "<br>";
}

// Test 6: Stats query
echo "<hr><h3>Testing Stats Query</h3>";
try {
    $statsQuery = "
        SELECT 
            COUNT(CASE WHEN status = 'active' THEN 1 END) as active_count,
            COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_count,
            COUNT(CASE WHEN status = 'expired' THEN 1 END) as expired_count,
            SUM(CASE WHEN status = 'active' THEN amount_paid ELSE 0 END) as active_revenue,
            SUM(CASE WHEN status = 'pending' THEN amount_paid ELSE 0 END) as pending_revenue
        FROM user_subscriptions
    ";
    $stats = $pdo->query($statsQuery)->fetch(PDO::FETCH_ASSOC);
    
    echo "✅ Stats query executed<br>";
    echo "Active: " . $stats['active_count'] . "<br>";
    echo "Pending: " . $stats['pending_count'] . "<br>";
} catch (Exception $e) {
    echo "❌ Stats query failed: " . $e->getMessage() . "<br>";
}

// Test 7: Check header file
echo "<hr><h3>Testing Header File</h3>";
if (file_exists('includes/header.php')) {
    echo "✅ header.php exists<br>";
    echo "Trying to include it...<br>";
    ob_start();
    try {
        include 'includes/header.php';
        $headerOutput = ob_get_clean();
        echo "✅ header.php included successfully<br>";
    } catch (Exception $e) {
        ob_end_clean();
        echo "❌ header.php error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ header.php NOT FOUND<br>";
}

echo "<hr><p><strong>If all tests pass, the issue is likely in the HTML/CSS rendering.</strong></p>";
?>
