<?php
// Test database connection for admin panel
// DELETE THIS FILE after testing!

require_once 'config.php';

echo "<h2>🔍 Admin Panel - Database Connection Test</h2>";
echo "<style>body{font-family:sans-serif;padding:20px;background:#f5f7fa;}</style>";

echo "<h3>Testing Connection...</h3>";

$pdo = getDBConnection();

if ($pdo) {
    echo "<p style='color:green;font-size:18px;'>✅ <strong>Database connection successful!</strong></p>";
    
    // Test 1: Check admins table
    try {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM admins");
        $result = $stmt->fetch();
        echo "<p>✅ Table 'admins' exists - Found {$result['count']} admin(s)</p>";
        
        // Show admins
        $stmt = $pdo->query("SELECT id, username, role, is_active FROM admins");
        $admins = $stmt->fetchAll();
        if (!empty($admins)) {
            echo "<h4>Admin Accounts:</h4><ul>";
            foreach ($admins as $admin) {
                $status = $admin['is_active'] ? '🟢 Active' : '🔴 Inactive';
                echo "<li>ID: {$admin['id']} | Username: <strong>{$admin['username']}</strong> | Role: {$admin['role']} | {$status}</li>";
            }
            echo "</ul>";
        }
    } catch (PDOException $e) {
        echo "<p style='color:orange;'>⚠️ Table 'admins' not found or error: " . $e->getMessage() . "</p>";
        echo "<p><strong>Action Required:</strong> Run admin_schema.sql in phpMyAdmin</p>";
    }
    
    // Test 2: Check admin_logs table
    try {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM admin_logs");
        $result = $stmt->fetch();
        echo "<p>✅ Table 'admin_logs' exists - {$result['count']} log(s)</p>";
    } catch (PDOException $e) {
        echo "<p style='color:orange;'>⚠️ Table 'admin_logs' not found or error: " . $e->getMessage() . "</p>";
        echo "<p><strong>Action Required:</strong> Run admin_schema.sql in phpMyAdmin</p>";
    }
    
    // Test 3: Check users table (from main app)
    try {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE is_deleted = 0");
        $result = $stmt->fetch();
        echo "<p>✅ Table 'users' exists - Found {$result['count']} user(s)</p>";
    } catch (PDOException $e) {
        echo "<p style='color:red;'>❌ Table 'users' error: " . $e->getMessage() . "</p>";
    }
    
    echo "<hr>";
    echo "<h3>✅ Connection Status: WORKING</h3>";
    echo "<p><a href='login.php' style='background:linear-gradient(135deg, #667eea 0%, #764ba2 100%);color:white;padding:10px 20px;text-decoration:none;border-radius:8px;display:inline-block;'>Go to Login Page</a></p>";
    
} else {
    echo "<p style='color:red;font-size:18px;'>❌ <strong>Database connection FAILED!</strong></p>";
    echo "<h4>Troubleshooting Steps:</h4>";
    echo "<ol>";
    echo "<li>Check database credentials in <code>admin/config.php</code></li>";
    echo "<li>Verify database name: <strong>playbdqv_engweb</strong></li>";
    echo "<li>Verify database user: <strong>playbdqv_engweb</strong></li>";
    echo "<li>Check if MySQL service is running</li>";
    echo "<li>Verify database user has proper permissions</li>";
    echo "</ol>";
    
    echo "<h4>Current Configuration:</h4>";
    echo "<ul>";
    echo "<li>Host: " . DB_HOST . "</li>";
    echo "<li>Database: " . DB_NAME . "</li>";
    echo "<li>User: " . DB_USER . "</li>";
    echo "<li>Password: " . str_repeat('*', strlen(DB_PASS)) . "</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p style='color:red;'><strong>⚠️ IMPORTANT: Delete this file (test_connection.php) after testing!</strong></p>";
?>
