# 🚀 Quick Installation Guide - Admin Panel

## Step 1: Upload Admin Folder
Upload the entire `admin` folder to your server:
```
Local: /Users/chanuxbro/Documents/ensi/admin/
Server: www.howdoyou.space/admin/
```

## Step 2: Run Database Schema
1. Open phpMyAdmin
2. Select database: `playbdqv_engweb`
3. Click "SQL" tab
4. Copy contents from `api/admin_schema.sql`
5. Click "Go"

✅ This creates 2 new tables:
- `admins` (for admin users)
- `admin_logs` (for activity tracking)

✅ Default admin account created:
- Username: `admin`
- Password: `admin123`

## Step 3: Access Admin Panel
Go to: **https://www.howdoyou.space/admin/**

Login with:
```
Username: admin
Password: admin123
```

## Step 4: Change Default Password (IMPORTANT!)
After first login, go to phpMyAdmin and run:

```sql
-- Generate new password hash in PHP:
-- echo password_hash('your_new_password', PASSWORD_DEFAULT);

UPDATE admins 
SET password_hash = 'your_new_hash_here' 
WHERE username = 'admin';
```

Or create a new admin and delete the default:

```sql
-- Create new admin
INSERT INTO admins (username, password_hash, full_name, email, role) 
VALUES ('yourusername', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Your Name', 'you@email.com', 'super_admin');

-- Delete default admin
DELETE FROM admins WHERE username = 'admin';
```

## ✅ You're Done!

Now you can:
- ✅ Create, edit, delete users
- ✅ Change user levels (0-10)
- ✅ View statistics
- ✅ Monitor activity logs
- ✅ Search and filter users

---

## 🎯 Quick Actions

### Add a User
1. Go to "👥 Users"
2. Click "+ Add User"
3. Fill in details (name, email, password, level)
4. Click "Add User"

### Edit a User
1. Go to "👥 Users"
2. Click ✏️ icon next to user
3. Modify details
4. Click "Update User"

### Delete a User
1. Go to "👥 Users"
2. Click 🗑️ icon next to user
3. Confirm deletion

---

## 🔒 Security Reminders

⚠️ **Change default password immediately!**
⚠️ **Always use HTTPS in production**
⚠️ **Keep config.php private** (don't share publicly)
⚠️ **Monitor activity logs regularly**

---

## 📞 Need Help?

Check `ADMIN_README.md` for detailed documentation including:
- Complete feature list
- Troubleshooting guide
- Security best practices
- Database schema details
