<?php
require_once 'config.php';
$adminId = requireAdminAuth();
$admin = getCurrentAdmin();

// Get statistics
$pdo = getDBConnection();

$stats = [
    'total_users' => 0,
    'active_users' => 0,
    'deleted_users' => 0,
    'verified_users' => 0,
    'users_today' => 0,
];

try {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE is_deleted = 0");
    $stats['total_users'] = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE is_deleted = 0 AND is_verified = 1");
    $stats['active_users'] = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE is_deleted = 1");
    $stats['deleted_users'] = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE is_deleted = 0 AND is_verified = 1");
    $stats['verified_users'] = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE DATE(created_at) = CURDATE()");
    $stats['users_today'] = $stmt->fetch()['total'];
} catch (Exception $e) {
    error_log("Stats query error: " . $e->getMessage());
}

// Get recent users
$recentUsers = [];
try {
    $stmt = $pdo->query("SELECT id, user_name, email, user_level, is_verified, created_at FROM users WHERE is_deleted = 0 ORDER BY created_at DESC LIMIT 10");
    $recentUsers = $stmt->fetchAll();
} catch (Exception $e) {
    error_log("Recent users query error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Admin Panel</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1>Dashboard</h1>
            <p>Welcome back, <?php echo htmlspecialchars($admin['full_name'] ?? $admin['username']); ?>!</p>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">👥</div>
                <div class="stat-content">
                    <h3><?php echo number_format($stats['total_users']); ?></h3>
                    <p>Total Users</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">✅</div>
                <div class="stat-content">
                    <h3><?php echo number_format($stats['verified_users']); ?></h3>
                    <p>Verified Users</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">📅</div>
                <div class="stat-content">
                    <h3><?php echo number_format($stats['users_today']); ?></h3>
                    <p>New Today</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">🗑️</div>
                <div class="stat-content">
                    <h3><?php echo number_format($stats['deleted_users']); ?></h3>
                    <p>Deleted Users</p>
                </div>
            </div>
        </div>

        <!-- Quick Actions Section -->
        <div class="content-card" style="margin-bottom: 30px;">
            <div class="card-header">
                <h2>🛠️ Quick Actions</h2>
            </div>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; padding: 20px;">
                <a href="app_settings.php" style="text-decoration: none;">
                    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 20px; border-radius: 12px; color: white; text-align: center; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
                        <div style="font-size: 32px; margin-bottom: 10px;">⚙️</div>
                        <h3 style="margin: 0 0 5px 0; font-size: 16px;">App Settings</h3>
                        <p style="margin: 0; font-size: 12px; opacity: 0.9;">Maintenance Mode & Controls</p>
                    </div>
                </a>
                <a href="users.php" style="text-decoration: none;">
                    <div style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); padding: 20px; border-radius: 12px; color: white; text-align: center; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
                        <div style="font-size: 32px; margin-bottom: 10px;">👥</div>
                        <h3 style="margin: 0 0 5px 0; font-size: 16px;">Manage Users</h3>
                        <p style="margin: 0; font-size: 12px; opacity: 0.9;">View & Edit Users</p>
                    </div>
                </a>
                <a href="sessions.php" style="text-decoration: none;">
                    <div style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); padding: 20px; border-radius: 12px; color: white; text-align: center; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
                        <div style="font-size: 32px; margin-bottom: 10px;">🔐</div>
                        <h3 style="margin: 0 0 5px 0; font-size: 16px;">User Sessions</h3>
                        <p style="margin: 0; font-size: 12px; opacity: 0.9;">Active Sessions</p>
                    </div>
                </a>
                <a href="comments.php" style="text-decoration: none;">
                    <div style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); padding: 20px; border-radius: 12px; color: white; text-align: center; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
                        <div style="font-size: 32px; margin-bottom: 10px;">💬</div>
                        <h3 style="margin: 0 0 5px 0; font-size: 16px;">Comments</h3>
                        <p style="margin: 0; font-size: 12px; opacity: 0.9;">Manage Comments</p>
                    </div>
                </a>
            </div>
        </div>
        
        <div class="content-card">
            <div class="card-header">
                <h2>Recent Users</h2>
                <a href="users.php" class="btn btn-primary">View All Users</a>
            </div>
            
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Level</th>
                            <th>Status</th>
                            <th>Joined</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recentUsers)): ?>
                            <tr>
                                <td colspan="6" style="text-align: center; padding: 30px; color: #999;">
                                    No users found
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($recentUsers as $user): ?>
                                <tr>
                                    <td><?php echo $user['id']; ?></td>
                                    <td><?php echo htmlspecialchars($user['user_name'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td>
                                        <?php 
                                        $levelColors = [
                                            'guest' => 'badge-level-0',
                                            'registered' => 'badge-level-3',
                                            'pro' => 'badge-level-7',
                                            'vip' => 'badge-level-10'
                                        ];
                                        $levelClass = $levelColors[$user['user_level']] ?? 'badge-level-3';
                                        $levelName = ucfirst($user['user_level']);
                                        ?>
                                        <span class="badge <?php echo $levelClass; ?>">
                                            <?php echo $levelName; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($user['is_verified']): ?>
                                            <span class="badge badge-success">Verified</span>
                                        <?php else: ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
