<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

try {
    $conn = getDBConnection();
    
    if (!$conn) {
        echo json_encode(['error' => 'Database connection failed']);
        exit;
    }
    
    $response = [
        'success' => true,
        'tables' => []
    ];
    
    // Check user_sessions table structure
    try {
        $stmt = $conn->query("SHOW COLUMNS FROM user_sessions");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['tables']['user_sessions'] = $columns;
    } catch (Exception $e) {
        $response['tables']['user_sessions'] = 'Error: ' . $e->getMessage();
    }
    
    // Check users table structure  
    try {
        $stmt = $conn->query("SHOW COLUMNS FROM users");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['tables']['users'] = $columns;
    } catch (Exception $e) {
        $response['tables']['users'] = 'Error: ' . $e->getMessage();
    }
    
    // Sample data from user_sessions if exists
    try {
        $stmt = $conn->query("SELECT * FROM user_sessions LIMIT 2");
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $response['sample_sessions'] = $data;
    } catch (Exception $e) {
        $response['sample_sessions'] = 'Error: ' . $e->getMessage();
    }
    
    echo json_encode($response, JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>