<?php
// Debug version of lessons API
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

try {
    $conn = getDBConnection();
    
    if (!$conn) {
        echo json_encode(['error' => 'DB connection failed']);
        exit;
    }
    
    $stmt = $conn->prepare("
        SELECT * FROM lessons 
        WHERE is_active = 1 
        ORDER BY level ASC, order_index ASC
    ");
    $stmt->execute();
    $lessons = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'count' => count($lessons),
        'lessons' => $lessons
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
