<?php
// Minimal TTS API test
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-API-Key, User-Agent');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    // Basic validation without security config
    $text = $_POST['text'] ?? '';
    
    if (empty($text)) {
        echo json_encode(['success' => false, 'message' => 'Text parameter is required']);
        exit;
    }
    
    // Just return success for now to test basic functionality
    echo json_encode([
        'success' => true,
        'message' => 'Basic API test successful',
        'text' => $text,
        'method' => $_SERVER['REQUEST_METHOD'],
        'headers' => [
            'api_key' => $_SERVER['HTTP_X_API_KEY'] ?? 'not_set',
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'not_set'
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>